<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\PolicySimulator;

class GoogleCloudPolicysimulatorV1ListReplayResultsResponse extends \Google\Collection
{
  protected $collection_key = 'replayResults';
  /**
   * @var string
   */
  public $nextPageToken;
  protected $replayResultsType = GoogleCloudPolicysimulatorV1ReplayResult::class;
  protected $replayResultsDataType = 'array';
  public $replayResults;

  /**
   * @param string
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * @param GoogleCloudPolicysimulatorV1ReplayResult[]
   */
  public function setReplayResults($replayResults)
  {
    $this->replayResults = $replayResults;
  }
  /**
   * @return GoogleCloudPolicysimulatorV1ReplayResult[]
   */
  public function getReplayResults()
  {
    return $this->replayResults;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudPolicysimulatorV1ListReplayResultsResponse::class, 'Google_Service_PolicySimulator_GoogleCloudPolicysimulatorV1ListReplayResultsResponse');
